let active = true;

chrome.storage.local.get('active', data => active = data.active ?? true);
chrome.storage.onChanged.addListener(ch => {
  if (ch.active) active = ch.active.newValue;
});

function showTip(link, text, isNoindex) {
  const tip = document.createElement('div');
  tip.className = 'noindex-tooltip ' + (isNoindex ? 'no' : 'yes');
  tip.textContent = text;
  document.body.appendChild(tip);

  const rect = link.getBoundingClientRect();
  tip.style.top = `${rect.top + window.scrollY - 25}px`;
  tip.style.left = `${rect.left + window.scrollX}px`;

  setTimeout(() => tip.remove(), 2500);
}

async function checkLink(link) {
  if (!active) return;
  if (!link || link.dataset.checking) return;
  link.dataset.checking = '1';

  try {
    const res = await fetch(link.href, { method: 'GET', mode: 'cors', credentials: 'omit', redirect: 'follow' });
    // 1) Cabecera X-Robots-Tag
    const xr = res.headers.get('x-robots-tag') || res.headers.get('X-Robots-Tag');
    if (xr) {
      const isNoIndexHeader = /(^|,|\s)noindex(\s|,|$)/i.test(xr);
      showTip(link, isNoIndexHeader ? 'NOINDEX (X‑Robots) 🔴' : 'INDEX (X‑Robots) 🟢', isNoIndexHeader);
      return;
    }

    // 2) Buscar meta robots en el HTML
    const text = await res.text();
    const metaMatch = text.match(/<meta[^>]+name=["']robots["'][^>]*content=["']([^"']+)["'][^>]*>/i);
    let isNo = false;
    if (metaMatch) {
      const content = metaMatch[1];
      isNo = /(^|,|\s)noindex(\s|,|$)/i.test(content);
    }
    showTip(link, isNo ? 'NOINDEX 🔴' : 'INDEX 🟢', isNo);
  } catch (err) {
    console.error('Error comprobando meta robots:', err);
    showTip(link, 'Error al comprobar', true);
  } finally {
    delete link.dataset.checking;
  }
}

document.addEventListener('mouseover', (e) => {
  const link = e.target.closest('a[href]');
  if (!link) return;
  checkLink(link);
});
