<?php
declare(strict_types=1);

session_start();
ini_set('display_errors', '0');
error_reporting(E_ALL);

$BASE_DIR = __DIR__;
$PASSWORD_HASH = password_hash('pon-aqui-tu-password-segura', PASSWORD_DEFAULT);
$ALLOWED_UPLOAD_EXT = ['jpg','jpeg','png','gif','pdf','zip','txt','csv','xlsx','docx','pptx','mp4','mp3','svg','webp','avi','mov'];
$EDITABLE_EXT = ['txt','php','html','css','js','json','md','xml','log','sh','yaml','ini', 'env', 'htaccess'];

$BASE_DIR = rtrim(realpath($BASE_DIR), DIRECTORY_SEPARATOR);
if ($BASE_DIR === false) { die('BASE_DIR no es válido'); }

function h($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }
function starts_with($str, $prefix){ return strpos($str, $prefix) === 0; }
function safe_path(string $base, string $path) {
    $joined = $base . DIRECTORY_SEPARATOR . ltrim($path, "/\\");
    $real = realpath($joined);
    if ($real === false) return null;
    $real = rtrim($real, DIRECTORY_SEPARATOR);
    return starts_with($real, $base) ? $real : null;
}
function rrmdir($dir) {
    if (!is_dir($dir)) return false;
    $items = array_diff(scandir($dir), ['.','..']);
    foreach ($items as $item) {
        $p = $dir . DIRECTORY_SEPARATOR . $item;
        if (is_dir($p)) rrmdir($p); else @unlink($p);
    }
    return @rmdir($dir);
}
function bytes_format(float $bytes): string {
    $units = ['B','KB','MB','GB','TB','PB'];
    $i = 0;
    while ($bytes >= 1024 && $i < count($units)-1) { $bytes/=1024; $i++; }
    return number_format($bytes, 2, ',', '.') . ' ' . $units[$i];
}
function get_icon($ext) {
    $ext = strtolower($ext);
    switch ($ext) {
        case 'dir': return '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M4 20h16a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2h-7.93a2 2 0 0 1-1.66-.9l-.82-1.2A2 2 0 0 0 7.93 3H4a2 2 0 0 0-2 2v13c0 1.1.9 2 2 2Z"></path></svg>';
        case 'up': return '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="m3 11 18-5v12L3 14v-3z"></path><path d="M11.6 16.8a3 3 0 0 0-5.2-1.6"></path></svg>';
        case 'jpg': case 'jpeg': case 'png': case 'gif': case 'webp': case 'svg': return '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><rect width="18" height="18" x="3" y="3" rx="2" ry="2"></rect><circle cx="9" cy="9" r="2"></circle><path d="m21 15-3.086-3.086a2 2 0 0 0-2.828 0L6 21"></path></svg>';
        case 'pdf': return '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M14.5 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V7.5L14.5 2z"></path><polyline points="14 2 14 8 20 8"></polyline><path d="M10 12v-1a2 2 0 0 1 2-2v0a2 2 0 0 1 2 2v1"></path><path d="M10 18h4"></path><path d="M12 18v-6"></path></svg>';
        case 'zip': case 'rar': case '7z': return '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M21 15v4a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2v-4"></path><polyline points="7 10 12 15 17 10"></polyline><line x1="12" y1="15" x2="12" y2="3"></line></svg>';
        default: return '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M14.5 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V7.5L14.5 2z"></path><polyline points="14 2 14 8 20 8"></polyline></svg>';
    }
}

if (empty($_SESSION['fm_csrf'])) $_SESSION['fm_csrf'] = bin2hex(random_bytes(16));
$CSRF = $_SESSION['fm_csrf'];

$logged = $_SESSION['fm_logged'] ?? false;
if ($_SERVER['REQUEST_METHOD'] === 'POST' && ($_POST['action'] ?? '') === 'login') {
    if (password_verify($_POST['password'] ?? '', $PASSWORD_HASH)) {
        $_SESSION['fm_logged'] = true;
        header('Location: ' . $_SERVER['REQUEST_URI']);
        exit;
    }
    $error = 'Contraseña incorrecta';
}
if (isset($_GET['logout'])) {
    session_unset();
    session_destroy();
    header('Location: ' . strtok($_SERVER['REQUEST_URI'], '?'));
    exit;
}
if (!$logged) {
    ?>
    <!doctype html><html lang="es"><head><meta charset="utf-8"><meta name="viewport" content="width=device-width, initial-scale=1.0"><title>Victor Misa - Login</title>
    <style>:root{--color-bg:#f1f5f9;--color-card:#fff;--color-text:#0f172a;--color-primary:#4f46e5;--color-primary-h:#4338ca;--color-border:#cbd5e1}body{font-family:system-ui,-apple-system,BlinkMacSystemFont,"Segoe UI",Roboto,"Helvetica Neue",Arial,sans-serif;display:flex;align-items:center;justify-content:center;min-height:100vh;background-color:var(--color-bg);margin:0}.login-card{background:var(--color-card);padding:2.5rem;border-radius:0.75rem;box-shadow:0 10px 25px rgba(0,0,0,.07);width:100%;max-width:380px;text-align:center}.login-card h3{margin:0 0 1.5rem;font-size:1.75rem;font-weight:600;color:var(--color-text)}.login-card .error{background:#fef2f2;color:#991b1b;padding:0.75rem;border-radius:0.375rem;margin-bottom:1.5rem;border:1px solid #fecaca}input{width:100%;box-sizing:border-box;padding:0.75rem 1rem;border:1px solid var(--color-border);border-radius:0.375rem;font-size:1rem;transition:all .2s}input:focus{border-color:var(--color-primary);outline:0;box-shadow:0 0 0 3px rgba(79,70,229,.2)}.btn{width:100%;padding:0.75rem;background-color:var(--color-primary);color:#fff;border:0;border-radius:0.375rem;font-size:1rem;font-weight:600;cursor:pointer;transition:background-color .2s;margin-top:1rem}.btn:hover{background-color:var(--color-primary-h)}</style></head>
    <body><div class="login-card"><form method="post" autocomplete="off"><h3>Acceso - Victor Misa</h3><?php if(!empty($error)):?><div class="error"><?=h($error)?></div><?php endif;?><input name="password" type="password" placeholder="Contraseña" required autofocus /><input type="hidden" name="action" value="login" /><button type="submit" class="btn">Entrar</button></form></div></body></html>
    <?php exit;
}

$dir_rel = trim((string)($_GET['dir'] ?? ''), "/\\");
$CUR_DIR = safe_path($BASE_DIR, $dir_rel) ?? $BASE_DIR;
$action = $_POST['action'] ?? $_GET['action'] ?? '';
$msg = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!isset($_POST['csrf']) || !hash_equals($CSRF, $_POST['csrf'])) { http_response_code(400); die("CSRF token inválido"); }
    $redirect_url = strtok($_SERVER['REQUEST_URI'], '?') . '?dir=' . urlencode($dir_rel);
    if ($action === 'mkdir' && !empty($_POST['name'])) {
        $name = basename((string)$_POST['name']);
        if ($name !== '' && $name !== '.' && $name !== '..') {
            $target = $CUR_DIR . DIRECTORY_SEPARATOR . $name;
            if (!file_exists($target)) @mkdir($target, 0755, true);
        }
    }
    if ($action === 'upload' && !empty($_FILES['file'])) {
        $up = $_FILES['file'];
        if (($up['error'] ?? UPLOAD_ERR_NO_FILE) === UPLOAD_ERR_OK) {
            $filename = basename((string)$up['name']);
            $is_allowed = true;
            if (!empty($ALLOWED_UPLOAD_EXT)) {
                $ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
                if ($ext === '' || !in_array($ext, $ALLOWED_UPLOAD_EXT, true)) {
                    $is_allowed = false;
                    $msg = 'Extensión no permitida: ' . h($ext);
                    $redirect_url .= '&msg=' . urlencode($msg);
                }
            }
            if ($is_allowed) {
                $dest = $CUR_DIR . DIRECTORY_SEPARATOR . $filename;
                @move_uploaded_file($up['tmp_name'], $dest);
            }
        }
    }
    if ($action === 'delete' && !empty($_POST['target'])) {
        $target_rel = (string)$_POST['target'];
        $target_real = safe_path($BASE_DIR, $dir_rel . DIRECTORY_SEPARATOR . $target_rel);
        if ($target_real !== null && file_exists($target_real)) {
            if (is_dir($target_real)) rrmdir($target_real); else @unlink($target_real);
        }
    }
    if ($action === 'rename' && !empty($_POST['old']) && !empty($_POST['newname'])) {
        $old = basename((string)$_POST['old']);
        $new = basename((string)$_POST['newname']);
        if ($new !== '' && $new !== '.' && $new !== '..') {
            $oldp = $CUR_DIR . DIRECTORY_SEPARATOR . $old;
            $newp = $CUR_DIR . DIRECTORY_SEPARATOR . $new;
            if (safe_path($BASE_DIR, $dir_rel . DIRECTORY_SEPARATOR . $old) && safe_path($BASE_DIR, $dir_rel . DIRECTORY_SEPARATOR . $new)) {
                @rename($oldp, $newp);
            }
        }
    }
    if ($action === 'save' && !empty($_POST['file'])) {
        $file_rel_path = (string)$_POST['file'];
        $file_path = safe_path($BASE_DIR, $file_rel_path);
        $ext = strtolower(pathinfo($file_rel_path, PATHINFO_EXTENSION));
        if ($file_path && is_file($file_path) && in_array($ext, $EDITABLE_EXT, true)) {
            @file_put_contents($file_path, $_POST['content'] ?? '');
            $redirect_url = strtok($_SERVER['REQUEST_URI'], '?') . '?dir=' . urlencode(dirname($file_rel_path));
        }
    }
    header('Location: ' . $redirect_url); exit;
}

if ($action === 'download' && !empty($_GET['file'])) {
    $file = basename((string)$_GET['file']);
    $fp = safe_path($BASE_DIR, $dir_rel . DIRECTORY_SEPARATOR . $file);
    if ($fp !== null && is_file($fp)) {
        header('Content-Description: File Transfer');
        header('Content-Type: application/octet-stream');
        header('Content-Disposition: attachment; filename="' . basename($fp) . '"');
        header('Content-Length: ' . filesize($fp));
        readfile($fp); exit;
    }
    http_response_code(404); echo 'Fichero no encontrado'; exit;
}

if ($action === 'edit' && !empty($_GET['file'])) {
    $file_rel_name = basename((string)$_GET['file']);
    $file_full_rel_path = rtrim($dir_rel . DIRECTORY_SEPARATOR . $file_rel_name, DIRECTORY_SEPARATOR);
    $file_path = safe_path($BASE_DIR, $file_full_rel_path);
    $ext = strtolower(pathinfo($file_rel_name, PATHINFO_EXTENSION));
    if ($file_path && is_file($file_path) && in_array($ext, $EDITABLE_EXT, true)) {
        $content = h(@file_get_contents($file_path));
        ?>
        <!doctype html><html lang="es"><head><meta charset="utf-8"><title>Editando <?=h($file_rel_name)?></title>
        <style>:root{--color-bg:#1e293b;--color-header:#0f172a;--color-text:#e2e8f0;--color-primary:#4f46e5;--color-primary-h:#4338ca;--color-success:#16a34a;--color-success-h:#15803d;--color-border:#334155}body{margin:0;font-family:monospace;background:var(--color-bg);color:var(--color-text)}.header{background:var(--color-header);padding:1rem 1.5rem;display:flex;justify-content:space-between;align-items:center;border-bottom:1px solid var(--color-border)}.filename{font-size:1rem;font-weight:bold}.controls{display:flex;gap:1rem}textarea{width:100%;height:calc(100vh - 65px);box-sizing:border-box;background:#0f172a;border:0;color:#e2e8f0;font-size:16px;padding:1rem;line-height:1.5;resize:none;outline:none}.btn{padding:0.6rem 1.2rem;border:0;border-radius:0.375rem;font-size:0.9rem;font-weight:600;cursor:pointer;transition:all .2s}.btn-success{background:var(--color-success);color:#fff}.btn-success:hover{background:var(--color-success-h)}a.btn{text-decoration:none;background:#334155;color:#fff}a.btn:hover{background:#475569}</style></head>
        <body><form method="post"><div class="header"><div class="filename">Editando: <?=h($file_full_rel_path)?></div><div class="controls"><a href="?dir=<?=urlencode($dir_rel)?>" class="btn">Cancelar</a><button type="submit" class="btn btn-success">Guardar Cambios</button></div></div><input type="hidden" name="csrf" value="<?=h($CSRF)?>"><input type="hidden" name="action" value="save"><input type="hidden" name="file" value="<?=h($file_full_rel_path)?>"><textarea name="content" spellcheck="false"><?=$content?></textarea></form></body></html>
        <?php exit;
    }
    http_response_code(404); echo 'Fichero no editable o no encontrado.'; exit;
}

$items_raw = array_diff(scandir($CUR_DIR), ['.','..']);
$dirs = [];
$files = [];
foreach ($items_raw as $item) {
    if (is_dir($CUR_DIR . DIRECTORY_SEPARATOR . $item)) $dirs[] = $item;
    else $files[] = $item;
}
natcasesort($dirs); natcasesort($files);
$items = array_merge($dirs, $files);

$breadcrumbs = [];
$rel = trim(substr($CUR_DIR, strlen($BASE_DIR)), DIRECTORY_SEPARATOR);
$parts = $rel === '' ? [] : explode(DIRECTORY_SEPARATOR, $rel);
$acc = '';
$breadcrumbs[] = ['name' => 'Raíz', 'rel' => ''];
foreach ($parts as $p) { $acc = ($acc === '' ? $p : ($acc . DIRECTORY_SEPARATOR . $p)); $breadcrumbs[] = ['name' => $p, 'rel' => $acc]; }
$msg = (string)($_GET['msg'] ?? '');

$disk_total = @disk_total_space($BASE_DIR);
$disk_free  = @disk_free_space($BASE_DIR);
$disk_used  = ($disk_total !== false && $disk_free !== false) ? max(0, $disk_total - $disk_free) : null;
$pct_used   = ($disk_total && $disk_total > 0 && $disk_used !== null) ? round(($disk_used / $disk_total) * 100, 1) : null;
?>
<!doctype html>
<html lang="es">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Victor Misa - File Manager</title>
  <style>
    :root{--color-bg:#f1f5f9;--color-card:#fff;--color-text:#0f172a;--color-text-muted:#64748b;--color-primary:#4f46e5;--color-primary-h:#4338ca;--color-secondary:#1e293b;--color-secondary-h:#0f172a;--color-danger:#dc2626;--color-danger-h:#b91c1c;--color-border:#e2e8f0;--border-radius:0.75rem;--shadow:0 4px 20px rgba(0,0,0,0.05)}
    body{font-family:system-ui,-apple-system,BlinkMacSystemFont,"Segoe UI",Roboto,"Helvetica Neue",Arial,sans-serif;margin:0;background-color:var(--color-bg);color:var(--color-text)}
    .wrap{max-width:1200px;margin:0 auto;padding:1.5rem}
    .top-bar{background:var(--color-card);padding:1rem 1.5rem;display:flex;align-items:center;justify-content:space-between;border-bottom:1px solid var(--color-border);box-shadow:var(--shadow)}
    .top-bar .title{font-size:1.25rem;font-weight:700;color:var(--color-primary)}
    .btn{display:inline-flex;align-items:center;gap:0.5rem;padding:0.6rem 1rem;border:0;border-radius:var(--border-radius);font-size:0.9rem;font-weight:500;cursor:pointer;transition:all .2s;text-decoration:none}
    .btn-primary{background-color:var(--color-primary);color:#fff}.btn-primary:hover{background-color:var(--color-primary-h)}
    .btn-secondary{background-color:var(--color-secondary);color:#fff}.btn-secondary:hover{background-color:var(--color-secondary-h)}
    .btn-icon{background:transparent;padding:0.4rem;color:var(--color-text-muted);border-radius:50%}.btn-icon:hover{background:#e2e8f0;color:var(--color-text)}
    .btn-icon.danger:hover{background:#fee2e2;color:var(--color-danger)}
    .header{margin-bottom:1.5rem}
    .breadcrumbs{display:flex;align-items:center;flex-wrap:wrap;gap:0.5rem;font-size:0.9rem;background:var(--color-card);padding:0.75rem 1rem;border-radius:var(--border-radius);box-shadow:var(--shadow)}
    .breadcrumbs a{color:var(--color-text-muted);text-decoration:none}.breadcrumbs a:hover{color:var(--color-primary)}.breadcrumbs span{color:#94a3b8}
    .msg{background:#dcfce7;color:#166534;padding:0.75rem;border:1px solid #bbf7d0;border-radius:var(--border-radius);margin-bottom:1.5rem}
    .grid{display:grid;grid-template-columns:repeat(auto-fit,minmax(300px,1fr));gap:1.5rem;margin-bottom:1.5rem}
    .card{background:var(--color-card);padding:1.5rem;border-radius:var(--border-radius);box-shadow:var(--shadow)}
    .card h4{margin:0 0 1rem;font-size:1.1rem;font-weight:600}
    input[type=file]{font-family:inherit;font-size:0.9rem}
    input[type=file]::file-selector-button{background:var(--color-primary);color:white;border:0;padding:0.5rem 0.8rem;border-radius:0.5rem;cursor:pointer;transition:all .2s;margin-right:1rem}
    input[type=file]::file-selector-button:hover{background:var(--color-primary-h)}
    .form-group{margin-bottom:1rem}
    .form-group input{width:100%;box-sizing:border-box;padding:0.6rem 0.8rem;border:1px solid var(--color-border);border-radius:0.5rem;font-size:0.9rem}
    .progress-bar{height:8px;background:#e9ecef;border-radius:999px;overflow:hidden;margin:0.5rem 0}
    .progress-bar div{height:100%;background:var(--color-primary);transition:width .2s}
    .info-list{font-size:0.9rem;color:var(--color-text-muted)}
    .info-list div{display:flex;justify-content:space-between;margin-bottom:0.25rem}
    .table-container{background:var(--color-card);border-radius:var(--border-radius);overflow:hidden;box-shadow:var(--shadow)}
    table{width:100%;border-collapse:collapse}
    th,td{padding:1rem;border-bottom:1px solid var(--color-border);text-align:left;font-size:0.9rem;white-space:nowrap}
    th{background:#f8fafc;font-weight:600;color:var(--color-text-muted)}
    tbody tr:last-child td{border-bottom:0}
    tbody tr:hover{background-color:#f8fafc}
    td.name a, td.name span {display:flex;align-items:center;gap:0.75rem;font-weight:500;text-decoration:none;color:var(--color-text)}
    td.name a:hover{color:var(--color-primary)}
    td.name svg{min-width:24px;color:var(--color-primary)}
    td.size,td.modified{color:var(--color-text-muted)}
    td.actions{display:flex;align-items:center;gap:0.25rem}
    .actions form{display:inline-flex;align-items:center;gap:0.5rem}
    .actions .rename-input{width:150px;padding:0.4rem 0.6rem}
    .footer{margin-top:2rem;text-align:center;font-size:0.85rem;color:var(--color-text-muted)}
    @media (max-width:768px){.top-bar{flex-direction:column;gap:1rem}.wrap{padding:1rem}.actions form{flex-direction:column;align-items:stretch;gap:0.5rem}.actions .rename-input{width:100%}}
  </style>
</head>
<body>

<div class="top-bar">
  <div class="title">Victor Misa</div>
  <a class="btn btn-secondary" href="?logout=1">Cerrar sesión</a>
</div>

<div class="wrap">
  <div class="header">
    <div class="breadcrumbs">
      <?php foreach($breadcrumbs as $i => $b): ?>
        <a href="?dir=<?=urlencode($b['rel'])?>"><?=h($b['name'])?></a>
        <?php if ($i < count($breadcrumbs) - 1) echo '<span>/</span>'; ?>
      <?php endforeach; ?>
    </div>
  </div>
  
  <?php if ($msg): ?><div class="msg"><?=h($msg)?></div><?php endif; ?>

  <div class="grid">
    <div class="card">
      <h4>Almacenamiento</h4>
      <?php if ($disk_total && $disk_free !== false): ?>
        <div class="info-list">
          <div><span>Usado</span><strong><?=h(bytes_format((float)$disk_used))?></strong></div>
          <div><span>Libre</span><strong><?=h(bytes_format((float)$disk_free))?></strong></div>
        </div>
        <div class="progress-bar"><div style="width:<?=h((string)$pct_used)?>%"></div></div>
        <div style="font-size:0.8rem;color:var(--color-text-muted);text-align:right">Total: <?=h(bytes_format((float)$disk_total))?></div>
      <?php else: ?>
        <div style="font-size:0.9rem;color:var(--color-text-muted)">No se pudo leer el uso de disco.</div>
      <?php endif; ?>
    </div>

    <div class="card">
      <h4>Subir Fichero</h4>
      <form method="post" enctype="multipart/form-data">
        <input type="hidden" name="csrf" value="<?=h($CSRF)?>">
        <input type="hidden" name="action" value="upload">
        <div class="form-group"><input type="file" name="file" required></div>
        <button type="submit" class="btn btn-primary">Subir</button>
      </form>
    </div>

    <div class="card">
      <h4>Crear Carpeta</h4>
      <form method="post">
        <input type="hidden" name="csrf" value="<?=h($CSRF)?>">
        <input type="hidden" name="action" value="mkdir">
        <div class="form-group"><input name="name" placeholder="Nombre de la carpeta" required></div>
        <button type="submit" class="btn btn-primary">Crear</button>
      </form>
    </div>
  </div>

  <div class="table-container">
    <table>
      <thead>
        <tr><th>Nombre</th><th>Tamaño</th><th>Modificado</th><th>Acciones</th></tr>
      </thead>
      <tbody>
        <?php if ($CUR_DIR !== $BASE_DIR):
            $parent_rel = dirname($dir_rel); ?>
            <tr>
              <td class="name"><a href="?dir=<?=urlencode($parent_rel === '.' ? '' : $parent_rel)?>"><?=get_icon('up')?> ..</a></td>
              <td class="size">--</td><td class="modified">--</td><td></td>
            </tr>
        <?php endif; ?>
        <?php foreach ($items as $it):
            $path = $CUR_DIR . DIRECTORY_SEPARATOR . $it;
            $is_dir = is_dir($path);
            $size = $is_dir ? '--' : bytes_format((float)@filesize($path));
            $mod = date('d/m/Y H:i', @filemtime($path) ?: time());
            $ext = $is_dir ? 'dir' : strtolower(pathinfo($it, PATHINFO_EXTENSION));
            $is_editable = !$is_dir && in_array($ext, $EDITABLE_EXT, true);
            ?>
            <tr>
              <td class="name">
                <?php if ($is_dir): ?>
                  <a href="?dir=<?=urlencode(trim($dir_rel . '/' . $it, '/'))?>"><?=get_icon($ext)?> <?=h($it)?></a>
                <?php else: ?>
                  <span><?=get_icon($ext)?> <?=h($it)?></span>
                <?php endif; ?>
              </td>
              <td class="size"><?=$size?></td>
              <td class="modified"><?=h($mod)?></td>
              <td class="actions">
                  <?php if ($is_editable): ?>
                    <a href="?dir=<?=urlencode($dir_rel)?>&action=edit&file=<?=urlencode($it)?>" class="btn btn-icon" title="Editar">
                      <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M17 3a2.828 2.828 0 1 1 4 4L7.5 20.5 2 22l1.5-5.5L17 3z"></path></svg>
                    </a>
                  <?php endif; ?>
                  <?php if (!$is_dir): ?>
                    <a href="?dir=<?=urlencode($dir_rel)?>&action=download&file=<?=urlencode($it)?>" class="btn btn-icon" title="Descargar">
                      <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M21 15v4a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2v-4"/><polyline points="7 10 12 15 17 10"/><line x1="12" y1="15" x2="12" y2="3"/></svg>
                    </a>
                  <?php endif; ?>
                  <form method="post">
                      <input type="hidden" name="csrf" value="<?=h($CSRF)?>">
                      <input type="hidden" name="action" value="rename">
                      <input type="hidden" name="old" value="<?=h($it)?>">
                      <input name="newname" placeholder="Nuevo nombre" class="form-group rename-input" style="margin:0" required>
                      <button type="submit" class="btn btn-icon" title="Renombrar">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M11 4H4a2 2 0 0 0-2 2v14a2 2 0 0 0 2 2h14a2 2 0 0 0 2-2v-7"/><path d="M18.5 2.5a2.121 2.121 0 0 1 3 3L12 15l-4 1 1-4 9.5-9.5z"/></svg>
                      </button>
                  </form>
                  <form method="post" onsubmit="return confirm('¿Confirmas el borrado permanente de \'<?=h(addslashes($it))?>\'?')">
                      <input type="hidden" name="csrf" value="<?=h($CSRF)?>">
                      <input type="hidden" name="action" value="delete">
                      <input type="hidden" name="target" value="<?=h($it)?>">
                      <button type="submit" class="btn btn-icon danger" title="Eliminar">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><polyline points="3 6 5 6 21 6"/><path d="M19 6v14a2 2 0 0 1-2 2H7a2 2 0 0 1-2-2V6m3 0V4a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v2"/><line x1="10" y1="11" x2="10" y2="17"/><line x1="14" y1="11" x2="14" y2="17"/></svg>
                      </button>
                  </form>
              </td>
            </tr>
        <?php endforeach; ?>
        <?php if (empty($items)): ?>
          <tr><td colspan="4" style="text-align:center;padding:2rem;color:var(--color-text-muted)">Esta carpeta está vacía.</td></tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
  <p class="footer">Creado por <a href="https://victormisa.com" target="_blank" rel="noopener">Víctor Misa</a> — https://victormisa.com</p>
</div>

</body>
</html>
